---
description: "Learn more about: DateTime functions"
title: "DateTime functions"
ms.date: 1/18/2023
ms.custom: "nonautomated-date"
---
# DateTime functions

These functions create and manipulate datetime and datetimezone values.

|Name|Description|
|------------|---------------|
|[DateTime.AddZone](datetime-addzone.md)|Adds timezone information to the datetime value.|
|[DateTime.Date](datetime-date.md)|Returns a date part from a DateTime value.|
|[DateTime.FixedLocalNow](datetime-fixedlocalnow.md)|Returns a DateTime value set to the current date and time on the system.|
|[DateTime.From](datetime-from.md)|Returns a datetime value from a value.|
|[DateTime.FromFileTime](datetime-fromfiletime.md)|Returns a DateTime value from the supplied number.|
|[DateTime.FromText](datetime-fromtext.md)|Creates a datetime from local and universal datetime formats.|
|[DateTime.IsInCurrentHour](datetime-isincurrenthour.md)|Indicates whether the given datetime value occurs during the current hour, as determined by the current date and time on the system.|
|[DateTime.IsInCurrentMinute](datetime-isincurrentminute.md)|Indicates whether the given datetime value occurs during the current minute, as determined by the current date and time on the system.|
|[DateTime.IsInCurrentSecond](datetime-isincurrentsecond.md)|Indicates whether the given datetime value occurs during the current second, as determined by the current date and time on the system.|
|[DateTime.IsInNextHour](datetime-isinnexthour.md)|Indicates whether the given datetime value occurs during the next hour, as determined by the current date and time on the system.|
|[DateTime.IsInNextMinute](datetime-isinnextminute.md)|Indicates whether the given datetime value occurs during the next minute, as determined by the current date and time on the system.|
|[DateTime.IsInNextNHours](datetime-isinnextnhours.md)|Indicates whether the given datetime value occurs during the next number of hours, as determined by the current date and time on the system.|
|[DateTime.IsInNextNMinutes](datetime-isinnextnminutes.md)|Indicates whether the given datetime value occurs during the next number of minutes, as determined by the current date and time on the system.|
|[DateTime.IsInNextNSeconds](datetime-isinnextnseconds.md)|Indicates whether the given datetime value occurs during the next number of seconds, as determined by the current date and time on the system.|
|[DateTime.IsInNextSecond](datetime-isinnextsecond.md)|Indicates whether the given datetime value occurs during the next second, as determined by the current date and time on the system.|
|[DateTime.IsInPreviousHour](datetime-isinprevioushour.md)|Indicates whether the given datetime value occurs during the previous hour, as determined by the current date and time on the system.|
|[DateTime.IsInPreviousMinute](datetime-isinpreviousminute.md)|Indicates whether the given datetime value occurs during the previous minute, as determined by the current date and time on the system.|
|[DateTime.IsInPreviousNHours](datetime-isinpreviousnhours.md)|Indicates whether the given datetime value occurs during the previous number of hours, as determined by the current date and time on the system.|
|[DateTime.IsInPreviousNMinutes](datetime-isinpreviousnminutes.md)|Indicates whether the given datetime value occurs during the previous number of minutes, as determined by the current date and time on the system.|
|[DateTime.IsInPreviousNSeconds](datetime-isinpreviousnseconds.md)|Indicates whether the given datetime value occurs during the previous number of seconds, as determined by the current date and time on the system.|
|[DateTime.IsInPreviousSecond](datetime-isinprevioussecond.md)|Indicates whether the given datetime value occurs during the previous second, as determined by the current date and time on the system.|
|[DateTime.LocalNow](datetime-localnow.md)|Returns a datetime value set to the current date and time on the system.|
|[DateTime.Time](datetime-time.md)|Returns a time part from a DateTime value.|
|[DateTime.ToRecord](datetime-torecord.md)|Returns a record containing parts of a DateTime value.|
|[DateTime.ToText](datetime-totext.md)|Returns a text value from a DateTime value.|
|[#datetime](sharpdatetime.md)|Creates a datetime value from year, month, day, hour, minute, and second.|
